# SHOPIFY INTEGRATION - ROUTES TO ADD

Add these routes to your Laravel routes file (likely in `routes/web.php` or in the MarketingBot routes section):

```php
use App\Extensions\MarketingBot\System\Http\Controllers\ShopifyController;

// Add these routes in the authenticated user section, grouped with other marketing-bot routes
Route::middleware(['auth'])->prefix('dashboard/user')->name('dashboard.user.')->group(function () {
    
    // Shopify Integration Routes
    Route::prefix('marketing-bot/shopify')->name('marketing-bot.shopify.')->group(function () {
        Route::get('settings', [ShopifyController::class, 'index'])->name('settings');
        Route::post('connect', [ShopifyController::class, 'connect'])->name('connect');
        Route::delete('disconnect', [ShopifyController::class, 'disconnect'])->name('disconnect');
        Route::post('sync', [ShopifyController::class, 'sync'])->name('sync');
        Route::get('status', [ShopifyController::class, 'syncStatus'])->name('status');
    });
    
});
```

## Route Explanation

- **GET /dashboard/user/marketing-bot/shopify/settings** - Shopify settings page
- **POST /dashboard/user/marketing-bot/shopify/connect** - Connect Shopify store
- **DELETE /dashboard/user/marketing-bot/shopify/disconnect** - Disconnect store
- **POST /dashboard/user/marketing-bot/shopify/sync** - Manual sync trigger
- **GET /dashboard/user/marketing-bot/shopify/status** - Get sync status (AJAX)

## Quick Setup Commands

```bash
# 1. Run migrations
php artisan migrate

# 2. Clear caches
php artisan config:clear
php artisan route:clear
php artisan view:clear

# 3. Check routes are registered
php artisan route:list | grep shopify
```
